
unit WebForm6;

interface

uses
  SysUtils, System.Web.Security, System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm6 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
		procedure RegisterBtn_Click(sender: System.Object; e: System.EventArgs);

  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		MyError: System.Web.UI.WebControls.Label;
		RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
		Name: System.Web.UI.WebControls.TextBox;
		Address: System.Web.UI.WebControls.TextBox;
		Tel: System.Web.UI.WebControls.TextBox;
		Fax: System.Web.UI.WebControls.TextBox;
		Contact: System.Web.UI.WebControls.TextBox;
		RequiredFieldValidator9: System.Web.UI.WebControls.RequiredFieldValidator;
		WebSite: System.Web.UI.WebControls.TextBox;
		RegularExpressionValidator1: System.Web.UI.WebControls.RegularExpressionValidator;
		RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
		Email: System.Web.UI.WebControls.TextBox;
		RequiredFieldValidator3: System.Web.UI.WebControls.RequiredFieldValidator;
		Password: System.Web.UI.WebControls.TextBox;
		RequiredFieldValidator4: System.Web.UI.WebControls.RequiredFieldValidator;
		CompareValidator1: System.Web.UI.WebControls.CompareValidator;
		ConfirmPassword: System.Web.UI.WebControls.TextBox;
		RegisterBtn: System.Web.UI.WebControls.Button;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
    procedure OnInit(e: EventArgs); override;
  end;

implementation

uses top, apptypes, developersDB;

var _top : CSTop;
    _AppTypes : csAppTypes;

procedure TWebForm6.Page_Load(sender: System.Object; e: System.EventArgs);
begin

self.RegisterBtn.CausesValidation:=False;

		RequiredFieldValidator1.Enabled:=false;
		RequiredFieldValidator9.Enabled:=false;
		RegularExpressionValidator1.Enabled:=false;
		RequiredFieldValidator2.Enabled:=false;
		RequiredFieldValidator3.Enabled:=false;
		RequiredFieldValidator4.Enabled:=false;
		CompareValidator1.Enabled:=false;

  // Put user code to initialize the page here
  topicHeading.Text:='Register to Octane Web Examples';
	topicDescription.Text:='if you want to add your Delphi 8 for .NET example, please first register...';

end;

procedure TWebForm6.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;

//  RegisterBtn.add_Click(RegisterBtn_Click);

  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

procedure TWebForm6.RegisterBtn_Click(sender: System.Object; e: System.EventArgs);
var
  DeveloperID:integer;
  Developer : TdevelopersDB;
  kuky: HttpCookie;
begin
  if not Page.IsValid = true Then Exit;
  //Add New Developer to CustomerDB database
  Developer := TdevelopersDB.create;


  DeveloperID := Developer.AddDeveloper(Server.HtmlEncode(Name.Text),
                                        Server.HtmlEncode(Address.Text),
                                        Server.HtmlEncode(WebSite.Text),
                                        Email.Text,
                                        Server.HtmlEncode(Tel.Text),
                                        Server.HtmlEncode(Fax.Text),
                                        Server.HtmlEncode(Contact.Text),
                                        Password.Text);
  if DeveloperID <> 0 then
  begin
    FormsAuthentication.SetAuthCookie(IntToStr(DeveloperID), false);
    kuky:=HttpCookie.create('owe_name');
    kuky.Value:=Server.HtmlEncode(Name.Text);
    Response.Cookies.Add(kuky);
    kuky.Free;
    Response.Redirect('webform5.aspx');
  end
  else
     MyError.Text := 'Registration failed. Another person has already registered under that email address!';
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm6.InitializeComponent;
begin
	Include(Self.RegisterBtn.Click, Self.RegisterBtn_Click);
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

